﻿package com {
	import br.com.stimuli.loading.BulkErrorEvent;
	import br.com.stimuli.loading.BulkLoader;
	import br.com.stimuli.loading.BulkProgressEvent;

	import caurina.transitions.Tweener;

	import flash.display.BitmapData;
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.display.Shape;
	import flash.events.Event;
	import flash.geom.Rectangle;

	import flash.text.TextFieldAutoSize;

	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;

	import org.papervision3d.cameras.Camera3D;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.materials.MovieMaterial;
	import org.papervision3d.materials.utils.MaterialsList;
	import org.papervision3d.materials.*;
	import org.papervision3d.render.BasicRenderEngine;
	import org.papervision3d.scenes.Scene3D;
	import org.papervision3d.view.Viewport3D;
	import org.papervision3d.view.layer.ViewportLayer;
	import org.papervision3d.objects.primitives.Cube;
	import org.papervision3d.core.math.Number3D;
	import org.papervision3d.view.layer.ViewportLayer;

	import org.papervision3d.modifiers.Twist;
	import org.papervision3d.core.math.Number3D;

	import gs.*;
	import gs.easing.*;

	public class Gallery extends Sprite {
		public var loader:BulkLoader;
		public var viewport:Viewport3D;
		public var scene:Scene3D;
		public var camera:Camera3D;
		public var renderer:BasicRenderEngine;
		public var galleryImagesCollection:Array;
		public var galleryGradsCollection:Array;
		public var galleryPlanesPosXCollection:Array;
		public var galleryPlanesPosZCollection:Array;
		public var galleryPlanesPosYCollection:Array;
		public var galleryPlanesRotYCollection:Array;
		public var txtPlanesCollection:Array;
		public var txtPlanes:Array;
		private var _galleryXMLLoaded:Boolean=false;
		private var _cubesHolder:DisplayObject3D;
		private var _txtPlanesHolder:DisplayObject3D;
		private var planesHolderMain:DisplayObject3D;
		private var _imageZoomed:Boolean=false;
		private var _currentPlaneIndex:uint=0;
		private var _firstPlaneZ:Number=0;
		private var _planesAreMoving:Boolean=false;
		private var _creation:Boolean = false;
		public var numBut:Number;
		public static const GALLERY_XML:String='xml/gallery.xml';
		public static const VIEWPORT_WIDTH:Number=1200;
		public static const VIEWPORT_HEIGHT:Number = 800;

		public var GALLERY_PLANE_WIDTH:Number;
		public var GALLERY_PLANE_HEIGHT:Number;

		public var angle_per:Number;
		public var angle_perGr:Number;

		public var tmpX:Number = 0;
		public var tmpY:Number = 0;
		public var tmpZ:Number = 0;
		public var tX:Number=0;
		public var tY:Number=0;
		public var tmpRotateX:Number=0;
		public var tmpRotateY:Number=0;
		public var tmpRotateZ:Number=0;

		public var whellDelta:int;
		public var holderRotation:int = 0;
		public var tempDelta:int = 1;
		private var blur:BlurFilter;
		private var rand01:int;
		private var firstModes:Boolean = false;
		public var zoomedPicId:Number ;
		public var zoomedPicId_prev:Number ;

		public var _root:MovieClip;

		private var CUBE_SIZE_X ;
		private var CUBE_SIZE_Y ;
		private var CUBE_SEG ;

		private var cube:Cube;
		private var cubeHolder:DisplayObject3D;
		private var cubeViewportArr : Array;
		private var cubeHolderArr : Array;
		private var HolderViewportArr : Array;
		private var matlist : MaterialsList;
		private var movMatFront : MovieMaterial;
		private var movMatBack : MovieMaterial;
		private var movMatTop : MovieMaterial;
		private var movMatBotm : MovieMaterial;
		private var movMatCol : MovieMaterial ;
		private var mcBack : MovieClip;
		private var mcTop : MovieClip;
		private var mcFront : MovieClip;
		private var mcBotm : MovieClip;
		private var HomeCoordsX : Array;
		private var ImagesArr : Array;
		private var ImgBmpDataArr : Array;
		private var inFirstTime :Boolean = false;

		private var MainLayer:ViewportLayer;

		public var overCube:Boolean = false;
		public var isRotateCube:Boolean = false;
		public var galleryCubeOver:Cube
		public var layerCubeOver:ViewportLayer;

		public var galleryCubePrev:Cube
		public var layerCubePrev:ViewportLayer;

		public var CubePicId:int = 1 ;
		public var CubePicIdPrev:int = 1 ;

		public var MouseXNumSt:Number ;
		public var MouseYNumSt:Number ;

		public var numCols:int;
		public var numPhoto:int = 0 ;

		public var isBack:Boolean = true;
		public var isTop:Boolean = false;
		public var isFront:Boolean = false;
		public var isBotm:Boolean = false;

		private var switchArr : uint ;

		private var WidthTxtArr : Array ;

		private var mcClose : MovieClip;
		private var controls : MovieClip;
		private var mcOver : MovieClip;
		private var mcMask : MovieClip;
		private var mcPrev : MovieClip;
		private var mcNext : MovieClip;
		private var autoplaymc : MovieClip;
		private var detector : MovieClip;
		private var autoplay:int;
		private var autoplayOn:Boolean = true;
		private var autoplayWasOn:Boolean = false;
		private var autoplayControlTemp:Number;

		private var twist : Twist;
		private	var tw:Twist;
		private	var angle:int = 0;
		private var angleArr:Array = [0];
		private var centerXArr:Array = [420];
		private var centerX:int ;

		private var isNext:Boolean ;
		public var isClosed:Boolean = false;
		public var animation_pic:Boolean = false;

		public function Gallery(rt:MovieClip) {
			_root = rt;
			trace("ok");
			loadImagesData();
		}

		private function loadImagesData():void {
			loader=new BulkLoader('galleryLoader');
			loader.addEventListener(BulkLoader.COMPLETE, onGalleryLoaded);
			loader.addEventListener(BulkLoader.PROGRESS,onGalleryLoadingProgress);
			loader.addEventListener(BulkErrorEvent.ERROR,onGalleryLoadingError);
			loader.add( GALLERY_XML );
			loader.start( 1 );
		}

		private function onGalleryLoaded( event:Event ):void {

			if (! _galleryXMLLoaded ) {
				galleryImagesCollection = new Array();
				var galleryImagesData:XML = loader.getXML(GALLERY_XML, true);

				CUBE_SIZE_X = int(galleryImagesData.@cube_width);
				CUBE_SIZE_Y = int(galleryImagesData.@cube_height);
				CUBE_SEG = int(galleryImagesData.@cube_segm);
				autoplay = int(galleryImagesData.@autoplay);

				for each (var image:XML in galleryImagesData.elements()) {
					var imageSrc:String = image.@src.toString();
					if (imageSrc && imageSrc.length > 0) {
						galleryImagesCollection.push( imageSrc );
						loader.add( imageSrc );
					}
				}

				_galleryXMLLoaded=true;
				loader.start( 1 );
			} else {
				init3DEngine();
			}
		}

		private function onGalleryLoadingProgress( event:BulkProgressEvent ):void {
			if (! _galleryXMLLoaded) {
				_root.MainScroll.dynamic_page_content.holder.mcIconLoader.IconLoader.thisText.text =  'LOADING IMAGES: ' + event.itemsLoaded + ' OF ' + event.itemsTotal;
				_root.MainScroll.dynamic_page_content.holder.mcIconLoader.IconLoader.thisText.autoSize = TextFieldAutoSize.CENTER;

			} else {
				_root.MainScroll.dynamic_page_content.holder.mcIconLoader.IconLoader.thisText.text =  'LOADING IMAGES: ' + event.itemsLoaded + ' OF ' + event.itemsTotal;
				if (event.itemsLoaded == event.itemsTotal ) { _root.MainScroll.dynamic_page_content.holder.mcIconLoader.gotoAndPlay('hide'); }
			}
		}

		private function onGalleryLoadingError( event:BulkErrorEvent ):void {
			if (! _galleryXMLLoaded) {
				trace( 'ERROR: Data xml loading failed.' );
			} else {
				trace( 'ERROR: Images loading failed.' );
			}
		}

		public function init3DEngine():void {

			viewport = new Viewport3D( stage.stageWidth, 600, false, true );
			viewport.x = -int(stage.stageWidth * 0.5);
			viewport.y = -65;

			trace("viewport.y = "+viewport.y)
			addChild( viewport );

			scene = new Scene3D();
			camera = new Camera3D();
			camera.zoom = 10 ;
			camera.focus = 100 ;

			renderer = new BasicRenderEngine();
			createGalleryImages();
			addEventListener( Event.ENTER_FRAME, render );
		}

		private function createGalleryImages():void {

			ImgBmpDataArr = new Array();
			//ImagesArr = new Array();

			for (var j : uint = 0; j < galleryImagesCollection.length; j++) {

				var bitmap_Data:BitmapData = loader.getBitmapData( galleryImagesCollection[j] );
				//var bitmap:Bitmap = loader.getBitmap(galleryImagesCollection[j] );
				ImgBmpDataArr.push(bitmap_Data);
				//trace(ImgBmpDataArr);

				if ( j == (galleryImagesCollection.length - 1) ) {
					addGalleryImages();
				}
			}
		}

		private function addGalleryImages():void {

			var mcColor : MovieClip = new spIc_color();
			movMatCol = new MovieMaterial(mcColor, true, true);
			movMatCol.interactive = true;
			movMatCol.smooth = false;

			for (var i : uint = 0; i < ImgBmpDataArr.length; i++) {
				//trace("iiiiiiiiii = " + i);
				if( i == 0){
					mcBack = new spBack();
					mcBack.ImageBitmapData = ImgBmpDataArr[i];

					movMatBack = new MovieMaterial(mcBack, true, true,false,new Rectangle(0,0,CUBE_SIZE_X, CUBE_SIZE_Y) );
					movMatBack.interactive = true;
					movMatBack.smooth = false;
				}
				if( i == 1){
					mcTop = new spBack();
					mcTop.ImageBitmapData = ImgBmpDataArr[i];

					movMatTop = new MovieMaterial(mcTop, true, true,false,new Rectangle(0,0,CUBE_SIZE_X, CUBE_SIZE_Y) );
					movMatTop.interactive = true;
					movMatTop.smooth = false;
				}
				if( i == 2){
					mcFront = new spFront();
					mcFront.ImageBitmapData = ImgBmpDataArr[i];

					movMatFront = new MovieMaterial(mcFront, true, true,false,new Rectangle( -CUBE_SIZE_X, -CUBE_SIZE_Y, CUBE_SIZE_X, CUBE_SIZE_Y) );
					movMatFront.interactive = true;
					movMatFront.smooth = false;
				}
				if( i == 3){
					mcBotm = new spFront();
					mcBotm.ImageBitmapData = ImgBmpDataArr[i];

					movMatBotm = new MovieMaterial(mcBotm, true, true,true,new Rectangle( -CUBE_SIZE_X, -CUBE_SIZE_Y,CUBE_SIZE_X, CUBE_SIZE_Y) );
					movMatBotm.interactive = true;
					movMatBotm.smooth = false;
				}
				if (i == (ImgBmpDataArr.length - 1)) {createCubes();}
			}
		}

		////////////////////////////////////////  CreateCubes  ////////////////////////////////////////////
		public function createCubes():void {

			_cubesHolder = new DisplayObject3D();
			scene.addChild( _cubesHolder );
			_cubesHolder.y = 300;
			_cubesHolder.z = 2000;

			//TweenLite.to(_cubesHolder, 0.8, { z:238, delay: 0.1, onComplete: myListenersOn });

			var nums_sideS : Array = new Array('back', 'top', 'front', 'bottom' ,'right', 'left');

			matlist = new MaterialsList();

			for (var j: uint = 0; j < nums_sideS.length; j++ ) {

				if ( j == 0 ) {
					matlist.addMaterial(movMatBack , nums_sideS[j]);
				}
				if ( j == 1 ) {
					matlist.addMaterial(movMatTop , nums_sideS[j]);
				}
				if ( j == 2 ) {
					matlist.addMaterial(movMatFront , nums_sideS[j]);
				}
				if ( j == 3 ) {
					matlist.addMaterial(movMatBotm , nums_sideS[j]);
				}
				if ( j == 4  || j == 5 ) {
					matlist.addMaterial(movMatCol , nums_sideS[j]);
				}
				//trace("j="+j);
			}
			cube = new Cube(matlist,
			CUBE_SIZE_X, CUBE_SIZE_Y, CUBE_SIZE_Y,
			CUBE_SEG, CUBE_SEG, CUBE_SEG);

			tw = new Twist(cube);

			cubeHolder = new DisplayObject3D();
			cubeHolder.rotationX = 180;
			cubeHolder.addChild( cube );
			_cubesHolder.addChild( cubeHolder );

			addEventListener( Event.ENTER_FRAME, render );
			addEventListener( Event.ENTER_FRAME, twistRender );
			centerX = 500 ;

			TweenMax.to(angleArr, 0.7, { endArray:[-60], ease:Expo.easeIn, delay:0.2, onComplete:function():void {
				TweenMax.to(angleArr, 0.7, { endArray:[0], ease:Back.easeOut });
			}
		});

		TweenLite.to(cubeHolder, 0.8, { rotationX : cubeHolder.rotationX - 90, ease : Expo.easeIn,delay:0.2,  onComplete:function():void {
			TweenMax.to(cubeHolder, 0.8, { rotationX : cubeHolder.rotationX - 90, ease:Back.easeOut });
		}
	});

	TweenLite.to(_cubesHolder, 1.2, { y:0, z:238, delay:0.7, ease:Expo.easeOut, onComplete: myListenersOn  });

	MainLayer = viewport.getChildLayer(_cubesHolder, true);
	MainLayer.alpha = 0;
	TweenLite.to(MainLayer, 1.2, { alpha: 1, delay:0.7, ease:Expo.easeOut });

	function myListenersOn():void {
		removeEventListener( Event.ENTER_FRAME, render );

		_root.MainScroll.dynamic_page_content.holder.cover.gotoAndStop("show");
		trace("GO");
		switchArr = 0;
		addButtons();
	}

}
private function addButtons():void {

	mcClose = new paperBtnClose();
	mcClose.y = 481;
	var topPosition:uint = _root.MainScroll.dynamic_page_content.holder.numChildren - 1;
	_root.MainScroll.dynamic_page_content.holder.addChildAt(mcClose,topPosition);

	controls = new MovieClip();
	controls.x = -int(CUBE_SIZE_X*0.5);
	MovieClip(root).MainScroll.dynamic_page_content.holder.hold_mc.addChild(controls);

	if (autoplay == 0) {
		autoplayOn = false;
	}
	if (autoplay != 0) {

		detector = new detect();
		detector.alpha = 0;
		controls.addChild(detector);
		_root.program.MouseMooveFunc(detector);

		autoplaymc = new autoplayMC();
		autoplaymc.autoplayControl = 0;
		autoplaymc.x = CUBE_SIZE_X-20;
		autoplaymc.y = 20;
		controls.addChild(autoplaymc);
		autoplaymc.alpha = 0;
		TweenLite.to(autoplaymc, 0.5, { alpha: 1 });

	}
	if (autoplay != 0 && autoplayOn) {
		autoplayFunction();
	}

	mcOver = new MovieClip();
	var child:Shape = new Shape();
	child.graphics.beginFill(0xFF0000,0);
	child.graphics.drawRect(0, 0, CUBE_SIZE_X, CUBE_SIZE_Y);
	child.graphics.endFill();
	mcOver.addChild(child);
	controls.addChild(mcOver);

	mcOver.addEventListener(MouseEvent.MOUSE_OVER, autoplayOver);
	mcOver.addEventListener(MouseEvent.MOUSE_OUT, autoplayOut);
	mcOver.addEventListener(MouseEvent.MOUSE_DOWN, autoplayClick);

	mcPrev = new prevBtn();
	mcPrev.x = -30;
	mcPrev.y = Math.round(CUBE_SIZE_Y * 0.5);
	controls.addChild(mcPrev);

	mcNext = new nextBtn();
	mcNext.x = CUBE_SIZE_X+30;
	mcNext.y = Math.round(CUBE_SIZE_Y*0.5);
	controls.addChild(mcNext);

}
private function autoplayFunction () {
	var tempTime:Number = autoplay - ( autoplay * ( autoplaymc.autoplayControl/1000) ) ;
	Tweener.addTween (autoplaymc, { autoplayControl:1000, time:tempTime, transition:"linear", onUpdate:autoplayUpdate, onComplete:autoplayComplete } );
}

private function autoplayUpdate () {

	var msk:MovieClip = autoplaymc.aMask as MovieClip;
	var degree:Number = autoplaymc.autoplayControl * 0.36;
	msk.graphics.clear();
	msk.graphics.beginFill (0x00FF00, 1);
	msk.graphics.moveTo (0, 0);
	msk.graphics.lineTo(0, -100);
	if (degree > 0) {msk.graphics.lineTo(100, -100)};
	if (degree > 90) {msk.graphics.lineTo(100, 100)};
	if (degree > 180) {msk.graphics.lineTo(-100, 100)};
	if (degree > 270) {msk.graphics.lineTo(-100, -100)};
	msk.graphics.lineTo(Math.sin(degree*2*Math.PI/360)*100, -Math.cos(degree*2*Math.PI/360)*100);
	msk.graphics.lineTo(0, 0);
	msk.graphics.endFill();
}

private function autoplayComplete () {
	var msk:MovieClip = autoplaymc.aMask as MovieClip;
	while (msk.numChildren > 0) {
		msk.removeChildAt(0);
	}
	nextImg();
}

private function autoplayOver (e:MouseEvent) {
	if (autoplay !== 0) {
		TweenLite.to(detector, 0.5, { alpha: 1 });
	}
}
private function autoplayOut (e:MouseEvent) {
	if (autoplay !== 0) {
		TweenLite.to(detector, 0.5, { alpha: 0 });
	}
}

private function autoplayClick (e:MouseEvent) {
	if (autoplayOn) {

		detector.gotoAndStop(2);
		autoplayOn = false;
		Tweener.removeTweens (autoplaymc);
	}
	else {
		detector.gotoAndStop(1);
		autoplayOn = true;
		autoplayFunction();
	}

}

////////////////////////////////////////////////////////////////  NEXT IMAGE  //////////////////////////////////////////////////////////////////////
public function nextImg():void {

	animation_pic = true;
	_root.MainScroll.dynamic_page_content.holder.cover.gotoAndStop("hide");

	addEventListener( Event.ENTER_FRAME, render );
	addEventListener( Event.ENTER_FRAME, twistRender );
	centerX = 500 ;
	Tweener.removeTweens (autoplaymc);
	autoplaymc.autoplayControl = 0;
	MovieClip(autoplaymc.aMask).graphics.clear();
	autoplayUpdate();
	TweenLite.to(controls, 0.3, { alpha: 0, onComplete:function():void { controls.visible = false; } } );

	TweenMax.to(angleArr, 0.7, { endArray:[-60], ease:Back.easeIn, onComplete:function():void {
		TweenMax.to(angleArr, 0.7, { endArray:[0], ease:Back.easeOut });
	}
});

TweenLite.to(cubeHolder, 0.8, { rotationX : cubeHolder.rotationX - 45, ease : Back.easeIn, onComplete:function():void {
	TweenMax.to(cubeHolder, 0.9, { rotationX : cubeHolder.rotationX - 45, ease:Back.easeOut, onComplete: ternComplete  });
}
});

if (numPhoto == (ImgBmpDataArr.length - 1) ) { numPhoto = 0 ; }else { numPhoto ++; }
var numPhotoTemp:uint = 0;
if (numPhoto == (ImgBmpDataArr.length - 1) ) {numPhotoTemp = 0 ; }else {	numPhotoTemp = numPhoto+1;	}

switch (switchArr) {
	case 0:
		isTop = true;
		switchArr = 1;
		mcFront.ImageBitmap = ImgBmpDataArr[numPhotoTemp];
		mcFront.play();
	break;
	case 1:
		isFront = true;
		switchArr = 2;
		mcBotm.ImageBitmap = ImgBmpDataArr[numPhotoTemp];
		mcBotm.play();
	break;
	case 2:
		isBotm = true;
		switchArr = 3;
		mcBack.ImageBitmap = ImgBmpDataArr[numPhotoTemp];
		mcBack.play();
	break;
	case 3:
		isBack = true;
		switchArr = 0;
		mcTop.ImageBitmap = ImgBmpDataArr[numPhotoTemp];
		mcTop.play();
	break;
}

}

////////////////////////////////////////////////////////////////  PREV IMAGE  //////////////////////////////////////////////////////////////////////
public function prevImg():void {

	_root.MainScroll.dynamic_page_content.holder.cover.gotoAndStop("hide");

	addEventListener( Event.ENTER_FRAME, render );
	addEventListener( Event.ENTER_FRAME, twistRender );
	centerX = -500 ;
	Tweener.removeTweens (autoplaymc);
	autoplaymc.autoplayControl = 0;
	MovieClip(autoplaymc.aMask).graphics.clear();
	autoplayUpdate();
	TweenLite.to(controls, 0.3, { alpha: 0, onComplete:function():void { controls.visible = false; } } );

	TweenMax.to(angleArr, 0.7, { endArray:[-60], ease:Back.easeIn, onComplete:function():void {
		TweenMax.to(angleArr, 0.7, { endArray:[0], ease:Back.easeOut });
	}
});

TweenLite.to(cubeHolder, 0.8, { rotationX : cubeHolder.rotationX + 45, ease : Back.easeIn, onComplete:function():void {
	TweenMax.to(cubeHolder, 0.9, { rotationX : cubeHolder.rotationX + 45, ease:Back.easeOut, onComplete: ternComplete  });
}
});

if (numPhoto == 0 ) { numPhoto = (ImgBmpDataArr.length - 1) ; }else { numPhoto --; }
var numPhotoTemp:uint = 0;
if (numPhoto == 0 ) { numPhotoTemp = (ImgBmpDataArr.length - 1) ; }else { numPhotoTemp = numPhoto-1; }

switch (switchArr) {
	case 0:
		isBotm = true;
		switchArr = 3;
		mcFront.ImageBitmap = ImgBmpDataArr[numPhotoTemp];
		mcFront.play();
	break;
	case 1:
		switchArr = 0;
		isBack = true;
		mcBotm.ImageBitmap = ImgBmpDataArr[numPhotoTemp];
		mcBotm.play();
	break;
	case 2:
		switchArr = 1;
		isTop = true;
		mcBack.ImageBitmap = ImgBmpDataArr[numPhotoTemp];
		mcBack.play();
	break;
	case 3:
		switchArr = 2;
		isFront = true;
		mcTop.ImageBitmap = ImgBmpDataArr[numPhotoTemp];
		mcTop.play();
	break;
}

}

private function ternComplete():void {

	trace("TERN COMPLETE");
	animation_pic = false;
	_root.MainScroll.dynamic_page_content.holder.cover.gotoAndStop("show");
	controls.visible = true;
	TweenLite.to(controls, 0.3, { alpha: 1 } );
	if (autoplay != 0 && autoplayOn) {
		autoplaymc.autoplayControl = 0;
		autoplayFunction();
	}
	removeEventListener( Event.ENTER_FRAME, twistRender );
	removeEventListener( Event.ENTER_FRAME, render );
	tw.twist(0, new Number3D(0, 0, 0), new Number3D(0, 0, 0));
}

public function closePaper():void {
	
	TweenLite.to(MovieClip(root).MainScroll.scrollMov.scroll_button, 1, { y: 0, ease:Expo.easeOut });
	TweenLite.to(MovieClip(root).MainScroll.dynamic_page_content, 1, { y: 0, ease:Expo.easeOut });
	
		if (!isClosed) {
			animation_pic = true;
			isClosed = true;
			_root.coverMovie.gotoAndStop("hide");
			TweenMax.to(_root.MainScroll.dynamic_page_content.holder.bg_sm, 1, { height:0,delay:0.8, ease:Expo.easeOut } );
			TweenMax.to(_root.MainScroll.dynamic_page_content.holder.bg_eff, 1, { alpha:0, delay:0.8, ease:Expo.easeOut, onComplete:function():void {
				_root.MainScroll.dynamic_page_content.holder.bg_eff.height = 0;
			}
		});
		TweenMax.to(_root.MainScroll.dynamic_page_content.holder.bg2, 1, { height:0, delay:0.9, ease:Expo.easeOut } );
		TweenMax.to(_root.MainScroll.dynamic_page_content.holder.bg1, 1, { height:20, y: -18, delay:1.1, ease:Expo.easeOut } );
		TweenMax.to(mcClose.arr_eff.arr, 1, { y: -491, delay:1.2, ease:Expo.easeOut, onComplete: function():void {
			TweenMax.to(mcClose.arr_eff.arr, 1, { rotation: 180, delay:0.1, ease:Elastic.easeOut });
		}
	});

	TweenMax.to(_root.MainScroll.dynamic_page_content.all, 1, {y:134, delay:1.3, ease:Expo.easeOut, onComplete: resize_Event  });
	TweenMax.to(_root.MainScroll.dynamic_page_content.footer_mc, 1, {y: (134 + _root.MainScroll.dynamic_page_content.all.height ), delay:1.3, ease:Expo.easeOut });

	addEventListener( Event.ENTER_FRAME, render );
	addEventListener( Event.ENTER_FRAME, twistRender );
	centerX = -500 ;

	TweenMax.to(angleArr, 0.7, { endArray:[-60], ease:Back.easeIn, onComplete:function():void {
		TweenMax.to(angleArr, 0.7, { endArray:[0], ease:Expo.easeOut });
	}
});

TweenLite.to(cubeHolder, 0.8, { rotationX : cubeHolder.rotationX + 45, ease : Back.easeIn, onComplete:function():void {
	TweenMax.to(cubeHolder, 0.8, { rotationX : cubeHolder.rotationX + 45, ease:Expo.easeOut });
}
});

TweenLite.to(_cubesHolder, 0.8, { y:350, z:2000, delay:0.7, ease:Expo.easeOut, onComplete: holderClosed } );
TweenLite.to(MainLayer, 0.8, { alpha: 0, delay:0.7, ease:Expo.easeOut });

TweenLite.to(controls, 0.4, { alpha: 0, onComplete:function():void { controls.visible = false; } });

if (autoplayOn) {
	detector.gotoAndStop(2);
	Tweener.removeTweens (autoplaymc);
	autoplaymc.autoplayControl = 0;
	MovieClip(autoplaymc.aMask).graphics.clear();
	autoplayUpdate();
}
}else {

	animation_pic = true;
	isClosed = false;
	_root.coverMovie.gotoAndStop("hide");
	_root.MainScroll.dynamic_page_content.holder.hold_mc.visible = true;

	TweenMax.to(_root.MainScroll.dynamic_page_content.holder.bg1, 1, { height:491, y: 0, delay:0.1, ease:Expo.easeInOut } );
	TweenMax.to(mcClose.arr_eff.arr, 1, { y: 0, delay:0.2, ease:Expo.easeInOut, onComplete: function():void {
		TweenMax.to(mcClose.arr_eff.arr, 1, { rotation: 0, delay:0.1, ease:Elastic.easeOut });
	}
});
TweenMax.to(_root.MainScroll.dynamic_page_content.holder.bg2, 1, { height:470, delay:0.3, ease:Expo.easeInOut } );
_root.MainScroll.dynamic_page_content.holder.bg_eff.height = 470;
TweenMax.to(_root.MainScroll.dynamic_page_content.holder.bg_eff, 1, { alpha:1, delay:0.5, ease:Expo.easeInOut } );
TweenMax.to(_root.MainScroll.dynamic_page_content.holder.bg_sm, 1, { height:470, delay:0.4, ease:Expo.easeInOut } );

TweenMax.to(_root.MainScroll.dynamic_page_content.all, 1, {y:625, ease:Expo.easeInOut, onComplete: resize_Event  });
TweenMax.to(_root.MainScroll.dynamic_page_content.footer_mc, 1, {y: (625 + _root.MainScroll.dynamic_page_content.all.height ), ease:Expo.easeInOut });

addEventListener( Event.ENTER_FRAME, render );
addEventListener( Event.ENTER_FRAME, twistRender );
centerX = 500 ;

TweenMax.to(angleArr, 0.7, { endArray:[-60], ease:Expo.easeIn, delay:0.2, onComplete:function():void {
	TweenMax.to(angleArr, 0.7, { endArray:[0], ease:Back.easeOut });
}
});

TweenLite.to(cubeHolder, 0.8, { rotationX : cubeHolder.rotationX - 45, ease : Expo.easeIn,delay:0.2,  onComplete:function():void {
	TweenMax.to(cubeHolder, 0.8, { rotationX : cubeHolder.rotationX - 45, ease:Back.easeOut });
}
});

TweenLite.to(_cubesHolder, 1.2, { y:0, z:238, delay:0.7, ease:Expo.easeOut, onComplete: holderOpened } );
TweenLite.to(MainLayer, 1.2, { alpha: 1, delay:0.7, ease:Expo.easeOut });
}


function resize_Event():void {
	stage.stageHeight =  _root.MainScroll.dynamic_page_content.height ;
	_root.program.contentScroll(_root.MainScroll.scrollMov.scroll_button,_root.MainScroll.scrollMov.track, _root.MainScroll.dynamic_page_content );
}

function holderClosed():void {
	animation_pic = false;
	_root.coverMovie.gotoAndStop("show");
	_root.MainScroll.dynamic_page_content.holder.hold_mc.visible = false;
	removeEventListener( Event.ENTER_FRAME, render );
	removeEventListener( Event.ENTER_FRAME, twistRender );
	tw.twist(0, new Number3D(0, 0, 0), new Number3D(0, 0, 0));
}

function holderOpened():void {
	animation_pic = false;
	_root.coverMovie.gotoAndStop("show");
	controls.visible = true;
	TweenLite.to(controls, 0.4, { alpha: 1 });

	autoplaymc.autoplayControl = 0;
	autoplayUpdate();
	if (autoplay != 0 && autoplayOn) {
		detector.gotoAndStop(1);
		autoplayFunction();
	}
	removeEventListener( Event.ENTER_FRAME, render );
	removeEventListener( Event.ENTER_FRAME, twistRender );
	tw.twist(0, new Number3D(0, 0, 0), new Number3D(0, 0, 0));
}
}

///////////////////   TWIST RENDERING FUNCTION  /////////////////////////
private function twistRender( event:Event ):void {
	tw.twist(angleArr[0], new Number3D(1, 0, 0), new Number3D(centerX, 0, 0));
}

///////////////////   SCENE RENDERING FUNCTION  /////////////////////////
private function render( event:Event ):void {
	renderer.renderScene( scene, camera, viewport );
}
//////////////////  SCENE ROTATE /////////////////////////
private function sceneRotate( event:Event ):void {
	/*
	var mouseXPos:Number = (root.mouseX - (stage.stageWidth*0.5)) / -(stage.stageWidth / 2);
	var mouseYPos:Number = (root.mouseY - (stage.stageHeight*0.5)) / -(stage.stageHeight / 2);

	var txtLen:int = txtPlanesCollection.length;
	for (var i: uint = 0; i < txtLen; i++ ) {
	var txtPlane:Plane = txtPlanesCollection[i] as Plane;
	var indRot: int ;
	if (((i + 1) % 2)) {
	indRot = 1;
	}else { indRot = -1; }
	TweenLite.to(txtPlane, 1, { rotationY : mouseXPos*indRot*20,ease : Expo.easeOut });
	}

	//TweenLite.to( _cubesHolder, 1, { rotationY: (mouseXPos * 10), rotationX: mouseYPos * -20, ease:Expo.easeOut } );
	*/
}

///////////////////////////
}
}

